/*
 * Decompiled with CFR 0.152.
 */
package com.qpaix.auth.config;

import com.qpaix.auth.entity.ActivationRequest;
import com.qpaix.auth.exception.BusinessException;
import com.qpaix.auth.repository.ActivationRequestRepository;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.core.userdetails.ReactiveUserDetailsService;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class CustomReactiveUserDetailsService
implements ReactiveUserDetailsService {
    private static final Log logger = LogFactory.getLog(CustomReactiveUserDetailsService.class);
    private final ActivationRequestRepository activationRequestRepository;
    private final PasswordEncoder passwordEncoder;

    public CustomReactiveUserDetailsService(ActivationRequestRepository activationRequestRepository, @Lazy PasswordEncoder passwordEncoder) {
        this.activationRequestRepository = activationRequestRepository;
        this.passwordEncoder = passwordEncoder;
    }

    public Mono<UserDetails> findByUsername(String username) {
        try {
            Optional activationRequestOptional = this.activationRequestRepository.findByEmailOrContact(username);
            if (activationRequestOptional.isPresent()) {
                ActivationRequest activationRequest = (ActivationRequest)activationRequestOptional.get();
                return Mono.just((Object)new User(activationRequest.getEmail().toLowerCase(), activationRequest.getPassword(), Collections.emptyList()));
            }
            throw new BusinessException(500, "ACCOUNT_DOES_NOT_EXIST");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"error in findByUsername :: CustomReactiveUserDetailsService ", (Throwable)e);
            throw new BusinessException(500, "Error while login");
        }
    }
}

