/*
 * Decompiled with CFR 0.152.
 */
package com.qpaix.auth.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.qpaix.auth.config.JwtTokenUtil;
import com.qpaix.auth.dto.RoleDTO;
import com.qpaix.auth.exception.BusinessError;
import com.qpaix.auth.exception.BusinessException;
import com.qpaix.auth.repository.RoleURLViewRepository;
import com.qpaix.auth.service.ConfigService;
import com.qpaix.auth.service.RedisService;
import com.qpaix.auth.util.EncryptionDecryption;
import io.jsonwebtoken.ExpiredJwtException;
import java.util.HashMap;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

@Component
public class JwtRequestFilter
implements WebFilter {
    @Autowired
    private JwtTokenUtil jwtTokenUtil;
    @Autowired
    private UserDetailsService jwtUserDetailsService;
    @Autowired
    @Lazy
    private EncryptionDecryption encryptionDecryption;
    @Autowired
    @Lazy
    private RoleURLViewRepository roleURLViewRepository;
    @Autowired
    @Lazy
    private RedisService redisService;
    @Value(value="${app.android.version}")
    private String androidVersion;
    @Value(value="${app.ios.version}")
    private String iosVersion;
    @Autowired
    @Lazy
    private ConfigService configService;
    private static final Log logger = LogFactory.getLog(JwtRequestFilter.class);

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        String requestTokenHeader = exchange.getRequest().getHeaders().getFirst("Authorization");
        String appVersion = exchange.getRequest().getHeaders().getFirst("App-Version");
        if (Objects.nonNull(appVersion) && this.configService.compareVersions(appVersion, this.androidVersion) < 0 && this.configService.compareVersions(appVersion, this.iosVersion) < 0) {
            throw new BusinessException(426, "APP_VERSION_MIS_MATCHED");
        }
        if (requestTokenHeader != null && requestTokenHeader.startsWith("Bearer ")) {
            String jwtToken = requestTokenHeader.substring(7);
            try {
                if (this.jwtTokenUtil.isTokenExpired(jwtToken)) {
                    throw new BusinessException(440, "SESSION_TIME_OUT");
                }
                String username = this.jwtTokenUtil.extractUsername(jwtToken);
                HashMap claims = this.jwtTokenUtil.extractClaims(jwtToken);
                if (claims.containsKey("PERSON_ID") && this.redisService.get((String)claims.get("PERSON_ID")) != null) {
                    throw new BusinessException(500, "PERSON_IS_NOT_LOGGED_IN");
                }
                if (claims.containsKey("IS_MOBILE")) {
                    int isMobile = (Integer)claims.get("IS_MOBILE");
                    String headerVersion = exchange.getRequest().getHeaders().getFirst("VERSION");
                    this.configService.checkVersion(headerVersion, isMobile);
                }
                return Mono.justOrEmpty((Object)username).flatMap(user -> {
                    UserDetails userDetails;
                    block8: {
                        userDetails = null;
                        try {
                            userDetails = this.jwtUserDetailsService.loadUserByUsername(user);
                        }
                        catch (Exception e) {
                            if (!(e instanceof BusinessException)) break block8;
                            BusinessError businessError = new BusinessError(((BusinessException)((Object)((Object)e))).getErrCode(), ((BusinessException)((Object)((Object)e))).getErrMsg());
                            ObjectMapper mapper = new ObjectMapper();
                            try {
                                byte[] errorBytes = mapper.writeValueAsBytes((Object)businessError);
                                ServerHttpResponse response = exchange.getResponse();
                                response.setStatusCode(HttpStatus.valueOf((int)((BusinessException)((Object)((Object)e))).getErrCode()));
                                response.getHeaders().setContentType(MediaType.APPLICATION_JSON);
                                DataBuffer buffer = response.bufferFactory().wrap(errorBytes);
                                return response.writeWith((Publisher)Mono.just((Object)buffer));
                            }
                            catch (Exception ex) {
                                return exchange.getResponse().setComplete();
                            }
                        }
                    }
                    if (this.jwtTokenUtil.validateToken(jwtToken, userDetails)) {
                        Long roleId;
                        UsernamePasswordAuthenticationToken authToken = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                        String encryptedRoleId = (String)claims.get("ROLE_ID");
                        if (encryptedRoleId == null) {
                            exchange.getResponse().setStatusCode(HttpStatus.FORBIDDEN);
                            return exchange.getResponse().setComplete();
                        }
                        try {
                            roleId = Long.valueOf(this.encryptionDecryption.decrypt(encryptedRoleId));
                        }
                        catch (Exception ex) {
                            Logger.getLogger(JwtRequestFilter.class.getName()).log(Level.SEVERE, null, ex);
                            exchange.getResponse().setStatusCode(HttpStatus.FORBIDDEN);
                            return exchange.getResponse().setComplete();
                        }
                        String roleName = (String)claims.get("ROLE");
                        RoleDTO role = new RoleDTO(roleId, roleName);
                        return this.isAuthorized(exchange, role).flatMap(isAuthorized -> {
                            if (!isAuthorized.booleanValue()) {
                                exchange.getResponse().setStatusCode(HttpStatus.FORBIDDEN);
                                return exchange.getResponse().setComplete();
                            }
                            return chain.filter(exchange).contextWrite((ContextView)ReactiveSecurityContextHolder.withAuthentication((Authentication)authToken));
                        });
                    }
                    exchange.getResponse().setStatusCode(HttpStatus.UNAUTHORIZED);
                    return exchange.getResponse().setComplete();
                });
            }
            catch (Exception e) {
                if (e instanceof ExpiredJwtException) {
                    BusinessError businessError = new BusinessError(440, "SESSION_TIME_OUT");
                    ObjectMapper mapper = new ObjectMapper();
                    try {
                        byte[] errorBytes = mapper.writeValueAsBytes((Object)businessError);
                        ServerHttpResponse response = exchange.getResponse();
                        response.setStatusCode(HttpStatus.UNAUTHORIZED);
                        response.getHeaders().setContentType(MediaType.APPLICATION_JSON);
                        DataBuffer buffer = response.bufferFactory().wrap(errorBytes);
                        return response.writeWith((Publisher)Mono.just((Object)buffer));
                    }
                    catch (Exception ex) {
                        return exchange.getResponse().setComplete();
                    }
                }
                if (e instanceof BusinessException) {
                    BusinessError businessError = new BusinessError(((BusinessException)((Object)e)).getErrCode(), ((BusinessException)((Object)e)).getErrMsg());
                    ObjectMapper mapper = new ObjectMapper();
                    try {
                        byte[] errorBytes = mapper.writeValueAsBytes((Object)businessError);
                        ServerHttpResponse response = exchange.getResponse();
                        response.setStatusCode(HttpStatus.valueOf((int)((BusinessException)((Object)e)).getErrCode()));
                        response.getHeaders().setContentType(MediaType.APPLICATION_JSON);
                        DataBuffer buffer = response.bufferFactory().wrap(errorBytes);
                        return response.writeWith((Publisher)Mono.just((Object)buffer));
                    }
                    catch (Exception ex) {
                        return exchange.getResponse().setComplete();
                    }
                }
                logger.error((Object)"error in jwtFilter :: JwtRequestFilter ", (Throwable)e);
                exchange.getResponse().setStatusCode(HttpStatus.FORBIDDEN);
                return exchange.getResponse().setComplete();
            }
        }
        return chain.filter(exchange);
    }

    private Mono<Boolean> isAuthorized(ServerWebExchange exchange, RoleDTO role) {
        String[] segments;
        String requestUrl = exchange.getRequest().getPath().value();
        int apiType = this.getApiType(exchange.getRequest().getMethod().name());
        StringBuilder searchURL = new StringBuilder();
        for (String segment : segments = requestUrl.split("/")) {
            if (segment.isEmpty()) continue;
            if (this.isDynamicSegment(segment)) {
                searchURL.append("/").append("{v}");
                continue;
            }
            searchURL.append("/").append(segment);
        }
        return Mono.fromCallable(() -> this.roleURLViewRepository.hasRights(role.getId(), apiType, searchURL.toString())).map(hasRight -> hasRight).defaultIfEmpty((Object)false);
    }

    private int getApiType(String requestMethod) {
        return switch (requestMethod) {
            case "GET" -> 1;
            case "POST" -> 2;
            case "DELETE" -> 3;
            case "PUT" -> 4;
            case "PATCH" -> 6;
            default -> 0;
        };
    }

    private boolean isDynamicSegment(String segment) {
        if (segment.matches("\\d+")) {
            return true;
        }
        return segment.length() >= 16 && segment.matches("^[A-Za-z0-9\\-_]+=*$") && segment.matches(".*[A-Z].*") && segment.matches(".*[a-z].*");
    }
}

