/*
 * Decompiled with CFR 0.152.
 */
package com.qpaix.auth.config;

import com.qpaix.auth.dto.PersonRoleViewDTO;
import com.qpaix.auth.exception.BusinessException;
import com.qpaix.auth.repository.ActivationRequestRepository;
import com.qpaix.auth.service.ConfigService;
import com.qpaix.auth.util.EncryptionDecryption;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;

@Component
public class JwtTokenUtil
implements Serializable {
    @Value(value="${token.extract.key}")
    private String secretKey;
    private static final long EXPIRATION_TIME = 259200000L;
    private static final long RESET_PASSWORD_EXPIRATION = 900000L;
    @Autowired
    @Lazy
    private EncryptionDecryption encryptionDecryption;
    @Autowired
    @Lazy
    private ActivationRequestRepository activationRequestRepository;
    @Autowired
    @Lazy
    private ConfigService configService;

    public String extractUsername(String token) {
        return (String)this.extractClaim(token, Claims::getSubject);
    }

    public String extractDataFromToken(String token) {
        if (!this.isTokenExpired(token)) {
            Claims claims = (Claims)Jwts.parser().setSigningKey(this.secretKey).parseClaimsJws(token).getBody();
            return (String)claims.get("data", String.class);
        }
        return null;
    }

    private Claims extractAllClaims(String token) {
        return (Claims)Jwts.parser().setSigningKey(this.secretKey).parseClaimsJws(token).getBody();
    }

    private <T> T extractClaim(String token, Function<Claims, T> claimsResolver) {
        Claims claims = this.extractAllClaims(token);
        return claimsResolver.apply(claims);
    }

    public String generateToken(String email, Long id, Long personId, PersonRoleViewDTO role, Long companyId, Long branchId, int isMobile) throws Exception {
        JwtBuilder builder = Jwts.builder().claim("EMAIL", (Object)email).claim("PERSON_ID", (Object)this.encryptionDecryption.encrypt((Object)personId)).setSubject(email).setIssuedAt(new Date(System.currentTimeMillis())).setExpiration(new Date(System.currentTimeMillis() + 259200000L)).signWith(SignatureAlgorithm.HS512, this.secretKey);
        if (id != null) {
            builder.claim("ID", (Object)this.encryptionDecryption.encrypt((Object)id));
        }
        if (role != null) {
            builder.claim("ROLE_ID", (Object)role.getRoleId());
            builder.claim("HIERARCHY", (Object)this.encryptionDecryption.encrypt((Object)role.getHierarchy()));
            builder.claim("ROLE", (Object)role.getName());
        }
        if (Objects.nonNull(companyId)) {
            builder.claim("COMPANY_ID", (Object)this.encryptionDecryption.encrypt((Object)companyId));
        }
        if (Objects.nonNull(branchId)) {
            builder.claim("BRANCH_ID", (Object)this.encryptionDecryption.encrypt((Object)branchId));
        }
        if (isMobile == 3) {
            builder.claim("IS_MOBILE", (Object)this.configService.getValueByName("IOS_VERSION"));
        } else if (isMobile == 2) {
            builder.claim("IS_MOBILE", (Object)this.configService.getValueByName("ANDROID_VERSION"));
        }
        return builder.compact();
    }

    public String generateResetToken(String data) {
        return Jwts.builder().claim("data", (Object)data).setSubject(data).setIssuedAt(new Date(System.currentTimeMillis())).setExpiration(new Date(System.currentTimeMillis() + 900000L)).signWith(SignatureAlgorithm.HS512, this.secretKey).compact();
    }

    public boolean validateToken(String token, UserDetails userDetails) {
        String username = this.extractUsername(token);
        return username.equals(userDetails.getUsername()) && !this.isTokenExpired(token);
    }

    public String validateToken(String token) {
        boolean flag = this.isTokenExpired(token);
        if (flag) {
            throw new BusinessException(99, "URL_EXPIRED");
        }
        String email = this.extractUsername(token);
        if (Objects.isNull(email)) {
            return null;
        }
        return email;
    }

    public boolean isTokenExpired(String token) {
        return this.extractExpiration(token).before(new Date());
    }

    public Date extractExpiration(String token) {
        return (Date)this.extractClaim(token, Claims::getExpiration);
    }

    public HashMap<String, Object> extractClaims(String token) {
        Claims claims = this.extractAllClaims(token);
        if (claims == null) {
            throw new BusinessException(401, "Claims not found in token");
        }
        HashMap<String, Object> claimMap = new HashMap<String, Object>();
        for (String key : claims.keySet()) {
            claimMap.put(key, claims.get((Object)key));
        }
        return claimMap;
    }

    public Map<String, Object> extractAllData(String token) {
        Claims claims = (Claims)Jwts.parser().setSigningKey(this.secretKey).parseClaimsJws(token).getBody();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("EMAIL", claims.getSubject());
        data.put("NAME", claims.containsKey((Object)"NAME") ? (String)claims.get((Object)"NAME") : null);
        data.put("COMPANY_ID", claims.containsKey((Object)"COMPANY_ID") ? (String)claims.get((Object)"COMPANY_ID") : null);
        data.put("ROLE_ID", claims.containsKey((Object)"ROLE_ID") ? (String)claims.get((Object)"ROLE_ID") : null);
        data.put("PERSON_ID", claims.containsKey((Object)"PERSON_ID") ? (String)claims.get((Object)"PERSON_ID") : null);
        data.put("HIERARCHY", claims.containsKey((Object)"HIERARCHY") ? (String)claims.get((Object)"HIERARCHY") : null);
        data.put("BRANCH_ID", claims.containsKey((Object)"BRANCH_ID") ? (String)claims.get((Object)"BRANCH_ID") : null);
        return data;
    }
}

