/*
 * Decompiled with CFR 0.152.
 */
package com.qpaix.auth.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.qpaix.auth.config.JwtTokenUtil;
import com.qpaix.auth.dto.ActivationRequestDTO;
import com.qpaix.auth.dto.TokenDetailsDTO;
import com.qpaix.auth.entity.JwtRequest;
import com.qpaix.auth.exception.BusinessException;
import com.qpaix.auth.service.ActivationService;
import com.qpaix.auth.service.ConfigService;
import com.qpaix.auth.util.ApiResponse;
import com.qpaix.auth.util.CommonUtil;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

@CrossOrigin(origins={"*"})
@RestController
@RequestMapping(value={"/auth/api"})
public class AuthController {
    @Autowired
    @Lazy
    private ActivationService activationService;
    @Autowired
    @Lazy
    private JwtTokenUtil jwtTokenUtil;
    @Autowired
    private ReactiveAuthenticationManager authenticationManager;
    @Autowired
    @Lazy
    private ObjectMapper objectMapper;
    @Autowired
    @Lazy
    private CommonUtil commonUtil;
    @Autowired
    @Lazy
    private ConfigService configService;

    @PostMapping(value={"/sign-up"})
    public ResponseEntity<ApiResponse<ActivationRequestDTO>> signUp(ServerHttpRequest request, @RequestBody ActivationRequestDTO activationRequestDTO) {
        this.activationService.signUp(activationRequestDTO, CommonUtil.getClientIpAddress((ServerHttpRequest)request), CommonUtil.getClientMacAddress((ServerHttpRequest)request));
        return ResponseEntity.ok().body((Object)new ApiResponse(true, Integer.valueOf(201), "Account Registered Successfully", (Object)activationRequestDTO, Integer.valueOf(1)));
    }

    @PostMapping(value={"/verify-otp"})
    public ResponseEntity<ApiResponse<ActivationRequestDTO>> verifyOtp(ServerHttpRequest request, @RequestBody ActivationRequestDTO activationRequestDTO) {
        return ResponseEntity.ok().body((Object)new ApiResponse(true, Integer.valueOf(200), "ACCOUNT_VERIFIED", (Object)this.activationService.verifyOTP(activationRequestDTO, CommonUtil.getClientIpAddress((ServerHttpRequest)request), CommonUtil.getClientMacAddress((ServerHttpRequest)request)), Integer.valueOf(0)));
    }

    @PostMapping(value={"/login"})
    public Mono<ResponseEntity<ApiResponse<ActivationRequestDTO>>> login(ServerHttpRequest request, @RequestBody JwtRequest authenticationRequest) {
        String username = authenticationRequest.getUsername();
        String password = authenticationRequest.getPassword();
        if (Objects.isNull(username) || Objects.isNull(password)) {
            return Mono.error((Throwable)new BusinessException(500, "Username or password must be provided"));
        }
        Integer deviceType = Integer.valueOf(Objects.nonNull(request.getHeaders().getFirst("deviceType")) ? request.getHeaders().getFirst("deviceType") : "0");
        return this.authenticate(username, password).flatMap(auth -> this.activationService.logIn(username, CommonUtil.getClientIpAddress((ServerHttpRequest)request), CommonUtil.getClientMacAddress((ServerHttpRequest)request), deviceType.intValue()).contextWrite((ContextView)ReactiveSecurityContextHolder.withAuthentication((Authentication)auth))).map(activationRequestDTO -> ResponseEntity.ok((Object)new ApiResponse(true, Integer.valueOf(200), "LOGIN_SUCCESSFULLY", activationRequestDTO, Integer.valueOf(0))));
    }

    private Mono<Authentication> authenticate(String username, String password) {
        return this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
    }

    @PostMapping(value={"/forgot-password"})
    public ResponseEntity<ApiResponse<String>> forgotPassword(@RequestBody ObjectNode map) throws JsonProcessingException {
        String data = (String)this.objectMapper.readValue(map.get("data").toString(), String.class);
        this.activationService.generateResetPasswordURL(data);
        return ResponseEntity.ok((Object)new ApiResponse(true, Integer.valueOf(200), "SUCCESS", (Object)"RESET_PASSWORD_URL_SENT_SUCCESSFULLY", Integer.valueOf(1)));
    }

    @PostMapping(value={"/validate-reset-token"})
    public ResponseEntity<ApiResponse<String>> validateResetToken(@RequestBody ObjectNode map) throws JsonProcessingException {
        String token = (String)this.objectMapper.readValue(map.get("token").toString(), String.class);
        if (Objects.isNull(token) || token.isBlank()) {
            throw new BusinessException(99, "INVALID_TOKEN");
        }
        String data = this.activationService.validateResetPasswordToken(token);
        return ResponseEntity.ok((Object)new ApiResponse(true, Integer.valueOf(200), "URL_VALIDATION_SUCCESSFUL", (Object)data, Integer.valueOf(1)));
    }

    @PostMapping(value={"/reset-password"})
    public ResponseEntity<ApiResponse<String>> updatePassword(@RequestBody ObjectNode map) throws JsonProcessingException {
        String token = (String)this.objectMapper.readValue(map.get("token").toString(), String.class);
        String newPassword = (String)this.objectMapper.readValue(map.get("newPassword").toString(), String.class);
        String data = this.jwtTokenUtil.extractDataFromToken(token);
        if (Objects.isNull(data)) {
            throw new BusinessException(500, "URL_EXPIRED");
        }
        this.activationService.updatePassword(data, newPassword);
        return ResponseEntity.ok((Object)new ApiResponse(true, Integer.valueOf(201), "UPDATED_SUCCESSFULLY", (Object)"PASSWORD_RESET_SUCCESSFULLY", Integer.valueOf(1)));
    }

    @PostMapping(value={"/resend-otp"})
    public ResponseEntity<ApiResponse<String>> resendOtp(@RequestBody ActivationRequestDTO activationRequestDTO) {
        this.activationService.reSendOTP(activationRequestDTO);
        return ResponseEntity.ok().body((Object)new ApiResponse(true, Integer.valueOf(200), "OTP_SENT_SECCESS", null, Integer.valueOf(0)));
    }

    @GetMapping(value={"/validate-token"})
    public ResponseEntity<ApiResponse<String>> validateToken(@RequestParam(value="token") String token) {
        this.jwtTokenUtil.validateToken(token);
        return ResponseEntity.ok().body((Object)new ApiResponse(true, Integer.valueOf(200), "VALID_TOKEN", null, Integer.valueOf(0)));
    }

    @PostMapping(value={"/validate-role"})
    public void validateRole(ServerHttpRequest request, @RequestBody ObjectNode map) throws Exception {
        String url = (String)this.objectMapper.readValue(map.get("url").toString(), String.class);
        TokenDetailsDTO tokenData = this.commonUtil.getDataFromToken(request);
        if (Objects.isNull(tokenData.getPersonId()) || Objects.isNull(tokenData.getEmail()) || Objects.isNull(tokenData.getRoleId())) {
            throw new BusinessException(401, "UNAUTHORIZED_ACCESS");
        }
        if (Objects.isNull(url) || url.isEmpty()) {
            throw new BusinessException(500, "INVALID_ROLE");
        }
        this.activationService.isAuthorized(url, tokenData.getRoleId());
    }

    @PostMapping(value={"/login/select-role"})
    public Mono<ResponseEntity<ApiResponse<ActivationRequestDTO>>> selectRoleAndLogin(ServerHttpRequest request, @RequestBody @Valid JwtRequest authenticationRequest) throws Exception {
        String encryptedRoleId = authenticationRequest.getEncryptedRoleId();
        TokenDetailsDTO tokenData = this.commonUtil.getDataFromToken(request);
        if (Objects.isNull(tokenData.getPersonId()) || Objects.isNull(tokenData.getEmail())) {
            throw new BusinessException(401, "UNAUTHORIZED_ACCESS");
        }
        if (Objects.isNull(encryptedRoleId)) {
            throw new BusinessException(401, "INVALID_ROLE");
        }
        Integer deviceType = Integer.valueOf(Objects.nonNull(request.getHeaders().getFirst("deviceType")) ? request.getHeaders().getFirst("deviceType") : "0");
        return Mono.just((Object)ResponseEntity.ok((Object)new ApiResponse(true, Integer.valueOf(202), "LOGIN_SUCCESSFULLY", (Object)this.activationService.setRoleAndLogin(tokenData.getEmail(), encryptedRoleId, CommonUtil.getClientIpAddress((ServerHttpRequest)request), CommonUtil.getClientMacAddress((ServerHttpRequest)request), deviceType.intValue()), Integer.valueOf(0))));
    }

    @PostMapping(value={"/logout"})
    public Mono<ResponseEntity<ApiResponse<String>>> logout(ServerHttpRequest request) throws Exception {
        TokenDetailsDTO tokenData = this.commonUtil.getDataFromToken(request);
        if (Objects.isNull(tokenData.getPersonId()) || Objects.isNull(tokenData.getEmail())) {
            throw new BusinessException(401, "UNAUTHORIZED_ACCESS");
        }
        ReactiveSecurityContextHolder.clearContext();
        this.activationService.logout(tokenData.getPersonId(), CommonUtil.getClientIpAddress((ServerHttpRequest)request), CommonUtil.getClientMacAddress((ServerHttpRequest)request));
        return Mono.just((Object)ResponseEntity.ok((Object)new ApiResponse(true, Integer.valueOf(200), "LOGOUT_SUCCESSFULLY", null, Integer.valueOf(0))));
    }

    @GetMapping(value={"/check-version"})
    public void checkAppVersion(ServerHttpRequest request) {
        String version = request.getHeaders().getFirst("version");
        if (Objects.isNull(version)) {
            throw new BusinessException(426, "INVALID_VERSION");
        }
        Integer deviceType = Integer.valueOf(request.getHeaders().getFirst("deviceType"));
        this.configService.checkVersion(version, deviceType.intValue());
    }
}

