/*
 * Decompiled with CFR 0.152.
 */
package com.qpaix.auth.controller;

import com.qpaix.auth.dto.PersonInfoDTO;
import com.qpaix.auth.service.PersonInfoService;
import com.qpaix.auth.util.ApiResponse;
import com.qpaix.auth.util.CommonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/persons"})
public class PersonInfoController {
    @Autowired
    @Lazy
    PersonInfoService personInfoService;

    @GetMapping(value={"/{encryptedPersonId}/exists"})
    public ResponseEntity<ApiResponse<Boolean>> checkPersonExist(@PathVariable String encryptedPersonId) throws Exception {
        return new ResponseEntity((Object)new ApiResponse(true, Integer.valueOf(HttpStatus.OK.value()), "SUCCESS", (Object)this.personInfoService.checkPersonExistById(encryptedPersonId), Integer.valueOf(0)), HttpStatus.OK);
    }

    @PutMapping(value={"/{encryptedPersonId}"})
    public void updatePersonDetails(ServerHttpRequest request, @PathVariable String encryptedPersonId, @RequestBody PersonInfoDTO personInfoDTO) {
        this.personInfoService.updatePeronDetail(personInfoDTO, CommonUtil.getClientIpAddress((ServerHttpRequest)request), CommonUtil.getClientMacAddress((ServerHttpRequest)request));
    }
}

