/*
 * Decompiled with CFR 0.152.
 */
package com.qpaix.auth.controller;

import com.qpaix.auth.dto.PortalDTO;
import com.qpaix.auth.dto.TokenDetailsDTO;
import com.qpaix.auth.exception.BusinessException;
import com.qpaix.auth.service.RolePortalService;
import com.qpaix.auth.util.ApiResponse;
import com.qpaix.auth.util.CommonUtil;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/portals"})
public class RolePortalController {
    @Autowired
    @Lazy
    private RolePortalService rolePortalService;
    @Autowired
    @Lazy
    private CommonUtil commonUtil;

    @GetMapping(value={""})
    public ResponseEntity<ApiResponse<List<PortalDTO>>> checkPersonExist(ServerHttpRequest request) throws Exception {
        TokenDetailsDTO tokenData = this.commonUtil.getDataFromToken(request);
        if (Objects.isNull(tokenData.getPersonId()) || Objects.isNull(tokenData.getEmail()) || Objects.isNull(tokenData.getRoleId())) {
            throw new BusinessException(401, "UNAUTHORIZED_ACCESS");
        }
        return new ResponseEntity((Object)new ApiResponse(true, Integer.valueOf(HttpStatus.OK.value()), "SUCCESS", (Object)this.rolePortalService.getPortalsByRoleId(tokenData.getRoleId()), Integer.valueOf(0)), HttpStatus.OK);
    }
}

