/*
 * Decompiled with CFR 0.152.
 */
package com.qpaix.auth.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.qpaix.auth.dto.PersonRoleViewDTO;
import java.util.List;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ActivationRequestDTO {
    @NotNull(message="Password is required")
    @NotBlank(message="Password cannot be blank")
    @Size(min=8, max=20, message="Password must be between 8 and 20 characters long")
    @Pattern(regexp="^(?=.*[A-Za-z])(?=.*\\d)(?=.*[@$!%*?&])[A-Za-z\\d@$!%*?&]+$", message="Password must contain at least one letter, one number, and one special character")
    private @NotNull(message="Password is required") @NotBlank(message="Password cannot be blank") @Size(min=8, max=20, message="Password must be between 8 and 20 characters long") @Pattern(regexp="^(?=.*[A-Za-z])(?=.*\\d)(?=.*[@$!%*?&])[A-Za-z\\d@$!%*?&]+$", message="Password must contain at least one letter, one number, and one special character") String password;
    @NotBlank(message="Contact number cannot be blank")
    @Pattern(regexp="\\d{10,15}", message="Contact number must be 10 to 15 digits long")
    private @NotBlank(message="Contact number cannot be blank") @Pattern(regexp="\\d{10,15}", message="Contact number must be 10 to 15 digits long") String contact;
    @NotBlank(message="Email cannot be blank")
    @Email(message="Invalid email format")
    private @NotBlank(message="Email cannot be blank") @Email(message="Invalid email format") String email;
    private String emailOtp;
    private String contactOtp;
    private String jwtToken;
    private String employeeId;
    private String encryptedProjectId;
    private boolean isContactVerified;
    private boolean isEmailVerified;
    private boolean isDetailSubmitted;
    private String encryptedPersonId;
    private List<PersonRoleViewDTO> roles;
    private boolean isTwoStepLogIn = false;
    private String firstName;
    private String lastName;
    private int status;
    private String name;
    private String role;

    public String getJwtToken() {
        return this.jwtToken;
    }

    public void setJwtToken(String jwtToken) {
        this.jwtToken = jwtToken;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmailOtp() {
        return this.emailOtp;
    }

    public String getContactOtp() {
        return this.contactOtp;
    }

    public String getEmployeeId() {
        return this.employeeId;
    }

    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }

    public void setEmailOtp(String emailOtp) {
        this.emailOtp = emailOtp;
    }

    public void setContactOtp(String contactOtp) {
        this.contactOtp = contactOtp;
    }

    public String getEncryptedProjectId() {
        return this.encryptedProjectId;
    }

    public void setEncryptedProjectId(String encryptedProjectId) {
        this.encryptedProjectId = encryptedProjectId;
    }

    public boolean isContactVerified() {
        return this.isContactVerified;
    }

    public void setIsContactVerified(boolean contactVerified) {
        this.isContactVerified = contactVerified;
    }

    public boolean isEmailVerified() {
        return this.isEmailVerified;
    }

    public void setIsEmailVerified(boolean emailVerified) {
        this.isEmailVerified = emailVerified;
    }

    public boolean isDetailSubmitted() {
        return this.isDetailSubmitted;
    }

    public void setDetailSubmitted(boolean detailSubmitted) {
        this.isDetailSubmitted = detailSubmitted;
    }

    public String getEncryptedPersonId() {
        return this.encryptedPersonId;
    }

    public void setEncryptedPersonId(String encryptedPersonId) {
        this.encryptedPersonId = encryptedPersonId;
    }

    public List<PersonRoleViewDTO> getRoles() {
        return this.roles;
    }

    public void setRoles(List<PersonRoleViewDTO> roles) {
        this.roles = roles;
    }

    public boolean isIsTwoStepLogIn() {
        return this.isTwoStepLogIn;
    }

    public void setIsTwoStepLogIn(boolean isTwoStepLogIn) {
        this.isTwoStepLogIn = isTwoStepLogIn;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public ActivationRequestDTO() {
    }

    public ActivationRequestDTO(String email, String contact) {
        this.email = email;
        this.contact = contact;
    }
}

