/*
 * Decompiled with CFR 0.152.
 */
package com.qpaix.auth.exception;

import com.qpaix.auth.exception.BusinessError;
import com.qpaix.auth.exception.BusinessException;
import io.jsonwebtoken.ExpiredJwtException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Log logger = LogFactory.getLog(GlobalExceptionHandler.class);

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<BusinessError> handleValidationExceptions(MethodArgumentNotValidException ex) {
        String firstErrorMessage = ((FieldError)ex.getBindingResult().getFieldErrors().get(0)).getDefaultMessage();
        BusinessError businessError = new BusinessError(400, firstErrorMessage);
        return new ResponseEntity((Object)businessError, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ExpiredJwtException.class})
    public ResponseEntity<BusinessError> handleExpiredJwtException(ExpiredJwtException ex) {
        HttpStatus status = HttpStatus.UNAUTHORIZED;
        BusinessError businessError = new BusinessError(440, "SESSION_TIME_OUT");
        ResponseEntity responseEntity = new ResponseEntity((Object)businessError, status);
        logger.error((Object)"Exception is--:", (Throwable)ex);
        return responseEntity;
    }

    @ExceptionHandler(value={BusinessException.class})
    public ResponseEntity<BusinessError> handleException(BusinessException ex) {
        BusinessError businessError;
        HttpStatus status = null;
        if (ex instanceof BusinessException) {
            status = ex.getErrCode() == 440 ? HttpStatus.UNAUTHORIZED : HttpStatus.valueOf((int)ex.getErrCode());
            businessError = new BusinessError(ex.getErrCode(), ex.getErrMsg());
        } else {
            status = HttpStatus.INTERNAL_SERVER_ERROR;
            businessError = new BusinessError(500, ex.getMessage());
        }
        ResponseEntity responseEntity = new ResponseEntity((Object)businessError, status);
        logger.error((Object)"Exception is--:", (Throwable)ex);
        return responseEntity;
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<BusinessError> handleException(Exception ex) {
        BusinessError businessError;
        HttpStatus status = null;
        if (ex instanceof BusinessException) {
            status = ((BusinessException)((Object)ex)).getErrCode() == 440 ? HttpStatus.UNAUTHORIZED : HttpStatus.valueOf((int)((BusinessException)((Object)ex)).getErrCode());
            businessError = new BusinessError(((BusinessException)((Object)ex)).getErrCode(), ((BusinessException)((Object)ex)).getErrMsg());
        } else {
            status = HttpStatus.INTERNAL_SERVER_ERROR;
            businessError = new BusinessError(500, ex.getMessage());
        }
        ResponseEntity responseEntity = new ResponseEntity((Object)businessError, status);
        logger.error((Object)"Exception is--:", (Throwable)ex);
        return responseEntity;
    }
}

