/*
 * Decompiled with CFR 0.152.
 */
package com.qpaix.auth.repository;

import com.qpaix.auth.entity.ActivationRequest;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ActivationRequestRepository
extends JpaRepository<ActivationRequest, Long> {
    @Query(value="select a from ActivationRequest a where a.personInfo.personId = :personId and a.isActive = true and a.isDeleted = false and a.personInfo.isActive = true and a.personInfo.isDeleted = false")
    public Optional<ActivationRequest> findByIdPersonId(@Param(value="personId") Long var1);

    @Query(value="select count(ar.id) from ActivationRequest ar where (ar.email = :email or ar.contact = :contact) and ar.isActive = true and ar.isDeleted = false")
    public int getCountByEmailOrContact(@Param(value="email") String var1, @Param(value="contact") String var2);

    @Query(value="select ar from ActivationRequest ar where (ar.email = :email or ar.contact = :contact) and ar.isActive = true and ar.isDeleted = false")
    public Optional<ActivationRequest> findByEmailOrContact(@Param(value="email") String var1, @Param(value="contact") String var2);

    @Query(value="select ar from ActivationRequest ar where ar.email = :email and ar.contact = :contact and ar.isActive = true and ar.isDeleted = false")
    public Optional<ActivationRequest> getActivationRequestByEmailAndContact(@Param(value="email") String var1, @Param(value="contact") String var2);

    @Query(value="SELECT ar FROM ActivationRequest ar LEFT JOIN FETCH ar.personInfo p WHERE (ar.email = :identifier OR ar.contact = :identifier) and ar.isActive = true and ar.isDeleted = false")
    public Optional<ActivationRequest> findByEmailOrContact(@Param(value="identifier") String var1);

    @Query(value="select count(a.id) from ActivationRequest a where a.email = :email and a.isActive = true and a.isDeleted = false and a.isPersonExist = false")
    public int isActivationRequestExistByEmail(@Param(value="email") String var1);

    @Query(value="select count(a.id) from ActivationRequest a where a.contact = :contact and a.isActive = true and a.isDeleted = false and a.isPersonExist = false")
    public int isActivationRequestExistByContact(@Param(value="contact") String var1);
}

