/*
 * Decompiled with CFR 0.152.
 */
package com.qpaix.auth.serviceimpl;

import com.qpaix.auth.config.JwtTokenUtil;
import com.qpaix.auth.dto.ActivationRequestDTO;
import com.qpaix.auth.dto.PersonRoleViewDTO;
import com.qpaix.auth.entity.ActivationRequest;
import com.qpaix.auth.entity.PersonInfo;
import com.qpaix.auth.entity.RoleView;
import com.qpaix.auth.exception.BusinessException;
import com.qpaix.auth.repository.ActivationRequestRepository;
import com.qpaix.auth.repository.PersonInfoRepository;
import com.qpaix.auth.repository.RoleURLViewRepository;
import com.qpaix.auth.repository.RoleViewRepository;
import com.qpaix.auth.service.ActivationService;
import com.qpaix.auth.service.EmailService;
import com.qpaix.auth.service.PersonRoleViewService;
import com.qpaix.auth.service.RedisService;
import com.qpaix.auth.util.EncryptionDecryption;
import com.qpaix.auth.webFluxService.OTPServiceClient;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.transaction.Transactional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class ActivationServiceImpl
implements ActivationService {
    @Autowired
    @Lazy
    private ActivationRequestRepository activationRequestRepository;
    @Autowired
    @Lazy
    private RedisService redisService;
    @Autowired
    @Lazy
    private EmailService emailService;
    @Autowired
    @Lazy
    private OTPServiceClient otpService;
    @Autowired
    @Lazy
    private JwtTokenUtil jwtTokenUtil;
    @Value(value="${reset.link}")
    private String resetLinkPrefix;
    @Autowired
    @Lazy
    private RoleURLViewRepository roleURLViewRepository;
    @Value(value="${email.service.config}")
    private Integer emailConfig;
    private static final Log logger = LogFactory.getLog(ActivationServiceImpl.class);
    private static final BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
    private static final String EMAIL_REGEX = "^[a-zA-Z0-9_+&*-]+(?:\\.[a-zA-Z0-9_+&*-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,7}$";
    private static final Pattern emailIdRegex = Pattern.compile("^[a-zA-Z0-9_+&*-]+(?:\\.[a-zA-Z0-9_+&*-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,7}$");
    @Autowired
    @Lazy
    private WebClient.Builder webClientBuilder;
    @Autowired
    @Lazy
    private PersonInfoRepository personInfoRepository;
    @Autowired
    @Lazy
    private EncryptionDecryption encryptionDecryption;
    @Autowired
    @Lazy
    private PersonRoleViewService personRoleViewService;
    @Autowired
    @Lazy
    private RoleViewRepository roleViewRepository;

    @Transactional
    public ActivationRequestDTO signUp(ActivationRequestDTO activationRequestDTO, String ipAddress, String macAddress) {
        ActivationRequest activationRequest = null;
        try {
            activationRequest = this.activationRequestRepository.findByEmailOrContact(activationRequestDTO.getEmail(), activationRequestDTO.getContact()).orElse(new ActivationRequest());
            if (Objects.nonNull(activationRequest.getId()) && activationRequest.isEmailVerified() && activationRequest.isContactVerified() && activationRequest.isEmailVerified() && activationRequest.isContactVerified()) {
                throw new BusinessException(500, "EMAIL_OR_CONTACT_ALREADY_EXIST");
            }
            activationRequest.setEmail(activationRequestDTO.getEmail());
            activationRequest.setContact(activationRequestDTO.getContact());
            activationRequest.setIpAddress(ipAddress);
            activationRequest.setMacAddress(macAddress);
            activationRequest.setPassword(passwordEncoder.encode((CharSequence)activationRequestDTO.getPassword()));
            activationRequestDTO.setPassword(null);
            this.sendOTP(activationRequestDTO);
            this.activationRequestRepository.save((Object)activationRequest);
            logger.info((Object)("user : " + activationRequest.getEmail() + " has been signed up"));
            return activationRequestDTO;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.info((Object)"Error in sendOTP :: ActivationServiceImpl", (Throwable)e);
            throw new BusinessException(500, "Couldn't sign up");
        }
    }

    @Async
    private void sendOTP(ActivationRequestDTO activationRequestDTO) {
        try {
            String emailOtp = "123456";
            String mobileOtp = "123456";
            this.saveMobileOtpAndEmailOtpToRedis(activationRequestDTO.getEmail(), null, emailOtp, null);
            String message = String.format("Your OTP is: %s. Please use this OTP to activate your account.\nNote : OTP is valid till next 15 minutes.", emailOtp);
            if (this.emailConfig == 1) {
                this.emailService.sendMail(activationRequestDTO.getEmail(), "OTP Verification", message);
            } else if (this.emailConfig == 2) {
                this.emailService.sendMail(activationRequestDTO.getEmail(), "OTP Verification", message, null, null, null);
            }
            Object contactNumber = activationRequestDTO.getContact().startsWith("+91") ? activationRequestDTO.getContact() : "+91" + activationRequestDTO.getContact();
            this.saveMobileOtpAndEmailOtpToRedis(null, (String)contactNumber, null, mobileOtp);
            message = String.format("Your OTP is: %s. Please use this OTP to activate your account.\nNote : OTP is valid till next 15 minutes.", mobileOtp);
            this.otpService.sendMobileOtp((String)contactNumber, message);
            logger.info((Object)("Email otp >>>>>>>>>  " + emailOtp));
            logger.info((Object)("Mobile otp >>>>>>>>>  " + mobileOtp));
        }
        catch (Exception e) {
            logger.info((Object)"Error in sendOTP :: ActivationServiceImpl", (Throwable)e);
            throw new BusinessException(500, "Error in sendOTP");
        }
    }

    public void reSendOTP(ActivationRequestDTO activationRequestDTO) {
        String message = null;
        String mobileOtp = null;
        String emailOtp = null;
        try {
            if (Objects.nonNull(activationRequestDTO.getEmail())) {
                if (this.activationRequestRepository.isActivationRequestExistByEmail(activationRequestDTO.getEmail()) != 1) {
                    logger.error((Object)("Could not send otp to email : " + activationRequestDTO.getEmail()));
                    throw new BusinessException(500, "Couldn't not send otp");
                }
                emailOtp = "123456";
                this.saveMobileOtpAndEmailOtpToRedis(activationRequestDTO.getEmail(), null, emailOtp, null);
                message = String.format("Your OTP is: %s. Please use this OTP to activate your account.\nNote : OTP is valid till next 15 minutes.", emailOtp);
                if (this.emailConfig == 1) {
                    this.emailService.sendMail(activationRequestDTO.getEmail(), "OTP Verification", message);
                } else if (this.emailConfig == 2) {
                    this.emailService.sendMail(activationRequestDTO.getEmail(), "OTP Verification", message, null, null, null);
                }
                logger.info((Object)("For Email : " + activationRequestDTO.getEmail() + " OTP : " + emailOtp));
            } else if (Objects.nonNull(activationRequestDTO.getContact())) {
                if (this.activationRequestRepository.isActivationRequestExistByContact(activationRequestDTO.getContact()) != 1) {
                    logger.error((Object)("Could not send otp to mobile : " + activationRequestDTO.getContact()));
                    throw new BusinessException(500, "Couldn't not send otp");
                }
                mobileOtp = "123456";
                Object contactNumber = activationRequestDTO.getContact().startsWith("+91") ? activationRequestDTO.getContact() : "+91" + activationRequestDTO.getContact();
                this.saveMobileOtpAndEmailOtpToRedis(null, (String)contactNumber, null, mobileOtp);
                message = String.format("Your OTP is: %s. Please use this OTP to activate your account.\nNote : OTP is valid till next 15 minutes.", mobileOtp);
                this.otpService.sendMobileOtp((String)contactNumber, message);
                logger.info((Object)("For contact : " + activationRequestDTO.getContact() + " OTP : " + mobileOtp));
            }
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.info((Object)"Error in reSendOTP :: ActivationServiceImpl", (Throwable)e);
            throw new BusinessException(500, "Error in sendOTP");
        }
    }

    @Async
    private void saveMobileOtpAndEmailOtpToRedis(String email, String mobile, String emailOTP, String mobileOTP) {
        try {
            if (Objects.nonNull(email)) {
                int count = Integer.parseInt(Objects.nonNull(this.redisService.get("RESEND_COUNT_PREFIX_" + email)) ? this.redisService.get("RESEND_COUNT_PREFIX_" + email) : "0");
                if (count > 4) {
                    throw new BusinessException(503, "RESENT_OTP_LIMIT_EXCEEDS");
                }
                this.redisService.store("OTP_" + email, emailOTP, 15L, TimeUnit.MINUTES);
                this.redisService.store("RESEND_COUNT_PREFIX_" + email, String.valueOf(++count), count == 6 ? 50L : 5L, TimeUnit.MINUTES);
            } else if (Objects.nonNull(mobile)) {
                int count = Integer.parseInt(Objects.nonNull(this.redisService.get("RESEND_COUNT_PREFIX_" + mobile)) ? this.redisService.get("RESEND_COUNT_PREFIX_" + mobile) : "0");
                if (count > 4) {
                    throw new BusinessException(99, "RESENT_OTP_LIMIT_EXCEEDS");
                }
                this.redisService.store("OTP_" + mobile, mobileOTP, 15L, TimeUnit.MINUTES);
                this.redisService.store("RESEND_COUNT_PREFIX_" + mobile, String.valueOf(++count), count == 6 ? 50L : 5L, TimeUnit.MINUTES);
            }
        }
        catch (BusinessException | NumberFormatException e) {
            throw e;
        }
        catch (Exception e) {
            logger.info((Object)"Error in validateCountAndSendOTP :: ActivationServiceImpl", (Throwable)e);
            throw e;
        }
    }

    @Transactional
    public ActivationRequestDTO verifyOTP(ActivationRequestDTO activationRequestDTO, String ipAdress, String macAddress) {
        ActivationRequest activationRequest = null;
        PersonInfo personInfo = null;
        String token = null;
        RoleView roleView = null;
        PersonRoleViewDTO personRoleViewDTO = new PersonRoleViewDTO();
        try {
            Optional activationRequestOptional = this.activationRequestRepository.getActivationRequestByEmailAndContact(activationRequestDTO.getEmail(), activationRequestDTO.getContact());
            if (activationRequestOptional.isPresent()) {
                activationRequest = (ActivationRequest)activationRequestOptional.get();
                String emailOtp = this.redisService.get("OTP_" + activationRequest.getEmail());
                if (Objects.isNull(emailOtp)) {
                    throw new BusinessException(99, "OTP_EXPIRED");
                }
                if (!Objects.equals(emailOtp, activationRequestDTO.getEmailOtp())) {
                    throw new BusinessException(500, "EMAIL_OTP_INVALID");
                }
                String contactOtp = this.redisService.get("OTP_" + (String)(activationRequest.getContact().startsWith("+91") ? activationRequest.getContact() : "+91" + activationRequest.getContact()));
                if (Objects.isNull(contactOtp)) {
                    throw new BusinessException(99, "OTP_EXPIRED");
                }
                if (!Objects.equals(contactOtp, activationRequestDTO.getContactOtp())) {
                    throw new BusinessException(500, "MOBILE_OTP_INVALID");
                }
                activationRequest.setActive(true);
                activationRequest.setContactVerified(true);
                activationRequest.setEmailVerified(true);
                activationRequest.setPersonExist(true);
                activationRequest.setIpAddress(ipAdress);
                activationRequest.setMacAddress(macAddress);
                personInfo = new PersonInfo();
                personInfo.setStatus(0);
                personInfo.setIpAddress(ipAdress);
                personInfo.setMacAddress(macAddress);
                this.personInfoRepository.save((Object)personInfo);
                activationRequest.setPersonInfo(personInfo);
                if (this.emailConfig == 1) {
                    this.emailService.sendMail(activationRequestDTO.getEmail(), "Account Registration", "Dear User,\n Your contact and email is verified successfully.");
                } else if (this.emailConfig == 2) {
                    this.emailService.sendMail(activationRequestDTO.getEmail(), "Account Registration", "Dear User,\n Your contact and email is verified successfully.", null, null, null);
                }
                this.activationRequestRepository.save((Object)activationRequest);
                activationRequestDTO = this.buildActivationRequestDTO(activationRequest, personInfo);
                roleView = (RoleView)this.roleViewRepository.findByHierarchy(7).get();
                personRoleViewDTO.setHierarchy(roleView.getHierarchy());
                personRoleViewDTO.setRoleId(this.encryptionDecryption.encrypt((Object)roleView.getId()));
                personRoleViewDTO.setName(roleView.getName());
                activationRequestDTO.setRole(roleView.getName());
                token = this.generateToken(activationRequestDTO, personInfo.getId(), personInfo.getId(), personRoleViewDTO, 1);
                activationRequestDTO.setJwtToken(token);
                return activationRequestDTO;
            }
            throw new BusinessException(99, "PERSON_NOT_FOUND");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.info((Object)"Error in VerifyOTP :: ActivationServiceImpl", (Throwable)e);
            throw new BusinessException(500, "SOMETHING_WENT_WRONG");
        }
    }

    @Transactional
    public Mono<ActivationRequestDTO> logIn(String username, String ipAddress, String macAddress, int isMobile) {
        ActivationRequestDTO activationRequestDTO = null;
        PersonInfo personInfo = null;
        List roleDTOs = null;
        String token = null;
        RoleView roleView = null;
        PersonRoleViewDTO personRoleViewDTO = new PersonRoleViewDTO();
        try {
            ActivationRequest activationRequest = (ActivationRequest)this.activationRequestRepository.findByEmailOrContact(username).orElseThrow(() -> new BusinessException(500, "ACCOUNT_DOES_NOT_EXIST"));
            if (activationRequest.isContactVerified() && activationRequest.isEmailVerified() && activationRequest.isPersonExist()) {
                personInfo = activationRequest.getPersonInfo();
                if (Objects.isNull(personInfo)) {
                    throw new BusinessException(500, "Person not found");
                }
                activationRequestDTO = this.buildActivationRequestDTO(activationRequest, personInfo);
                this.updateActivationRequest(activationRequest, ipAddress, macAddress);
                if (personInfo.isSystemAdmin()) {
                    Optional roleViewOptional = this.roleViewRepository.findByHierarchy(1);
                    if (roleViewOptional.isPresent()) {
                        roleView = (RoleView)roleViewOptional.get();
                    }
                    personRoleViewDTO.setHierarchy(roleView.getHierarchy());
                    personRoleViewDTO.setRoleId(this.encryptionDecryption.encrypt((Object)roleView.getId()));
                    personRoleViewDTO.setName(roleView.getName());
                    token = this.generateToken(activationRequestDTO, personInfo.getId(), personInfo.getPersonId(), personRoleViewDTO, isMobile);
                    activationRequestDTO.setRole(roleView.getName());
                    activationRequestDTO.setJwtToken(token);
                    return Mono.just((Object)activationRequestDTO);
                }
                if (!personInfo.isDetailsSubmitted()) {
                    Optional roleViewOptional = this.roleViewRepository.findByHierarchy(7);
                    if (roleViewOptional.isPresent()) {
                        roleView = (RoleView)roleViewOptional.get();
                    }
                    personRoleViewDTO.setHierarchy(roleView.getHierarchy());
                    personRoleViewDTO.setRoleId(this.encryptionDecryption.encrypt((Object)roleView.getId()));
                    personRoleViewDTO.setName(roleView.getName());
                    token = this.generateToken(activationRequestDTO, personInfo.getId(), personInfo.getPersonId(), personRoleViewDTO, isMobile);
                    activationRequestDTO.setRole(roleView.getName());
                    activationRequestDTO.setJwtToken(token);
                    return Mono.just((Object)activationRequestDTO);
                }
                if (personInfo.isDetailsSubmitted() && personInfo.getStatus() == 2 || personInfo.getStatus() == 0) {
                    Optional roleViewOptional = this.roleViewRepository.findByHierarchy(7);
                    if (roleViewOptional.isPresent()) {
                        roleView = (RoleView)roleViewOptional.get();
                    }
                    personRoleViewDTO.setHierarchy(roleView.getHierarchy());
                    personRoleViewDTO.setRoleId(this.encryptionDecryption.encrypt((Object)roleView.getId()));
                    personRoleViewDTO.setName(roleView.getName());
                    token = this.generateToken(activationRequestDTO, personInfo.getId(), personInfo.getPersonId(), personRoleViewDTO, personInfo.getCompanyId(), personInfo.getBranchId(), isMobile);
                    activationRequestDTO.setRole(roleView.getName());
                    activationRequestDTO.setJwtToken(token);
                    return Mono.just((Object)activationRequestDTO);
                }
                if (personInfo.isDetailsSubmitted() && personInfo.getStatus() == 1) {
                    roleDTOs = this.personRoleViewService.getAssignedRolesByPersonId(personInfo.getPersonId());
                    if (roleDTOs.isEmpty()) {
                        logger.info((Object)("No assigned roles found for person : " + activationRequest.getEmail()));
                        throw new BusinessException(500, "COMPANY_OR_BRANCH_OR_DEPARTMENT_OR_DESIGNATION_DOES_NOT_EXIST");
                    }
                    if (roleDTOs.size() == 1) {
                        token = this.generateToken(activationRequestDTO, personInfo.getId(), personInfo.getPersonId(), (PersonRoleViewDTO)roleDTOs.get(0), personInfo.getCompanyId(), personInfo.getBranchId(), isMobile);
                        activationRequestDTO.setRole(((PersonRoleViewDTO)roleDTOs.get(0)).getName());
                        activationRequestDTO.setJwtToken(token);
                        return Mono.just((Object)activationRequestDTO);
                    }
                    personRoleViewDTO = roleDTOs.stream().filter(ele -> ele.isDefault()).findAny().orElse(roleDTOs.stream().filter(ele -> ele.getHierarchy() == 7).findFirst().orElse(new PersonRoleViewDTO()));
                    token = this.generateToken(activationRequestDTO, personInfo.getId(), personInfo.getPersonId(), personRoleViewDTO, personInfo.getCompanyId(), personInfo.getBranchId(), isMobile);
                    activationRequestDTO.setJwtToken(token);
                    if (!personRoleViewDTO.isDefault()) {
                        activationRequestDTO.setIsTwoStepLogIn(true);
                    }
                    activationRequestDTO.setRoles(roleDTOs);
                    activationRequestDTO.setRole(personRoleViewDTO.getName());
                    return Mono.just((Object)activationRequestDTO);
                }
                this.redisService.clear(String.valueOf(personInfo.getPersonId()));
            } else {
                activationRequestDTO = this.buildActivationRequestDTO(activationRequest, null);
                this.sendOTP(activationRequestDTO);
            }
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"error in logIn :: ActivationServiceImpl ", (Throwable)e);
            throw new BusinessException(500, "COULD_NOT_LOGIN");
        }
        return Mono.just((Object)activationRequestDTO);
    }

    private ActivationRequestDTO buildActivationRequestDTO(ActivationRequest activationRequest, PersonInfo personInfo) {
        ActivationRequestDTO activationRequestDTO = new ActivationRequestDTO();
        activationRequestDTO.setEmail(activationRequest.getEmail());
        activationRequestDTO.setContact(activationRequest.getContact());
        if (personInfo != null) {
            activationRequestDTO.setIsContactVerified(activationRequest.isContactVerified());
            activationRequestDTO.setIsEmailVerified(activationRequest.isEmailVerified());
            activationRequestDTO.setDetailSubmitted(personInfo.isDetailsSubmitted());
            activationRequestDTO.setEmployeeId(personInfo.getEmployeeId());
            activationRequestDTO.setStatus(personInfo.getStatus());
            activationRequestDTO.setName((personInfo.getFirstName() + " " + personInfo.getLastName()).toUpperCase());
        } else {
            activationRequestDTO.setIsContactVerified(false);
            activationRequestDTO.setIsEmailVerified(false);
        }
        return activationRequestDTO;
    }

    private String generateToken(ActivationRequestDTO activationRequestDTO, Long personId, int isMobile) throws Exception {
        return this.jwtTokenUtil.generateToken(activationRequestDTO.getEmail(), null, personId, null, null, null, isMobile);
    }

    private String generateToken(ActivationRequestDTO activationRequestDTO, Long id, Long personId, PersonRoleViewDTO role, int isMobile) throws Exception {
        return this.jwtTokenUtil.generateToken(activationRequestDTO.getEmail(), id, personId, role, null, null, isMobile);
    }

    private String generateToken(ActivationRequestDTO activationRequestDTO, Long id, Long personId, PersonRoleViewDTO role, Long companyId, Long branchId, int isMobile) throws Exception {
        return this.jwtTokenUtil.generateToken(activationRequestDTO.getEmail(), id, personId, role, companyId, branchId, isMobile);
    }

    private void updateActivationRequest(ActivationRequest activationRequest, String ipAddress, String macAddress) {
        activationRequest.setLoginDate(new Timestamp(new Date().getTime()));
        activationRequest.setIpAddress(ipAddress);
        activationRequest.setMacAddress(macAddress);
        this.activationRequestRepository.save((Object)activationRequest);
    }

    @Transactional
    public ActivationRequestDTO setRoleAndLogin(String username, String encryptedRoleId, String ipAddress, String macAddress, int isMobile) {
        ActivationRequestDTO activationRequestDTO = null;
        PersonInfo personInfo = null;
        String token = null;
        Object encryptedPersonId = null;
        PersonRoleViewDTO personRoleViewDTO = null;
        List roleDTOs = null;
        try {
            ActivationRequest activationRequest = (ActivationRequest)this.activationRequestRepository.findByEmailOrContact(username).orElseThrow(() -> new BusinessException(500, "ACCOUNT_DOES_NOT_EXIST"));
            if (activationRequest.isContactVerified() && activationRequest.isEmailVerified() && activationRequest.isPersonExist()) {
                personInfo = activationRequest.getPersonInfo();
                if (Objects.isNull(personInfo)) {
                    throw new BusinessException(500, "Person not found");
                }
                if (!personInfo.isDetailsSubmitted()) {
                    throw new BusinessException(500, "PERSON_HAS_NOT_SUBMITTED_DETAILS");
                }
                roleDTOs = this.personRoleViewService.getAssignedRolesByPersonId(personInfo.getPersonId());
                personRoleViewDTO = roleDTOs.stream().filter(ele -> ele.getRoleId().equals(encryptedRoleId)).findAny().orElse(new PersonRoleViewDTO());
                if (!Objects.nonNull(personRoleViewDTO)) {
                    logger.error((Object)"INVALID_ROLE");
                    throw new BusinessException(500, "Role is not assigned to user");
                }
            } else {
                throw new BusinessException(500, "COULD_NOT_LOGIN");
            }
            roleDTOs.remove(personRoleViewDTO);
            activationRequest.setLoginDate(new Timestamp(new Date().getTime()));
            activationRequest.setIpAddress(ipAddress);
            activationRequest.setMacAddress(macAddress);
            this.activationRequestRepository.save((Object)activationRequest);
            this.redisService.clear(String.valueOf(personInfo.getPersonId()));
            logger.info((Object)("user : " + activationRequest.getEmail() + " has been logged in with two step login "));
            activationRequestDTO = this.buildActivationRequestDTO(activationRequest, personInfo);
            token = this.jwtTokenUtil.generateToken(activationRequestDTO.getEmail(), personInfo.getId(), personInfo.getPersonId(), personRoleViewDTO, personInfo.getCompanyId(), personInfo.getBranchId(), isMobile);
            activationRequestDTO.setJwtToken(token);
            activationRequestDTO.setRoles(roleDTOs);
            activationRequestDTO.setRole(personRoleViewDTO.getName());
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"error in logIn :: ActivationServiceImpl ", (Throwable)e);
            throw new BusinessException(500, "Couldn't login");
        }
        return activationRequestDTO;
    }

    public void generateResetPasswordURL(String data) {
        ActivationRequest activationRequest = null;
        String forgotToken = null;
        String resetLink = null;
        try {
            Optional activationRequestOptional = this.activationRequestRepository.findByEmailOrContact(data);
            if (!activationRequestOptional.isPresent()) {
                logger.error((Object)("User not found : " + activationRequest.getEmail()));
                throw new BusinessException(500, "ACCOUNT_DOES_NOT_EXIST");
            }
            activationRequest = (ActivationRequest)activationRequestOptional.get();
            if (Objects.nonNull(activationRequest)) {
                if (data.startsWith("+91") && data.length() == 10) {
                    forgotToken = this.jwtTokenUtil.generateResetToken(activationRequest.getContact());
                    resetLink = this.resetLinkPrefix + forgotToken;
                } else {
                    forgotToken = this.jwtTokenUtil.generateResetToken(activationRequest.getEmail());
                    resetLink = this.resetLinkPrefix + forgotToken;
                    if (this.emailConfig == 1) {
                        this.emailService.sendMail(data, "Reset Password", "To reset your password, click the link below :\n" + resetLink);
                    } else if (this.emailConfig == 2) {
                        this.emailService.sendMail(data, "Reset Password", "To reset your password, click the link below :\n" + resetLink, null, null, null);
                    }
                }
                this.redisService.store("RESET_URL_TOKEN_PREFIX" + activationRequest.getEmail(), forgotToken, 10L, TimeUnit.MINUTES);
                logger.info((Object)("URL generated for user : " + data));
            }
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"Error in generateResetPasswordURL :: ActivationServiceImpl ", (Throwable)e);
            throw new BusinessException(500, "SOMETHING_WENT_WRONG");
        }
    }

    public String validateResetPasswordToken(String token) {
        String data = null;
        try {
            data = this.jwtTokenUtil.validateToken(token);
            if (Objects.isNull(this.redisService.get("RESET_URL_TOKEN_PREFIX" + data))) {
                throw new BusinessException(500, "URL_EXPIRED");
            }
            if (!Objects.equals(this.redisService.get("RESET_URL_TOKEN_PREFIX" + data), token)) {
                throw new BusinessException(500, "PASSWORD_IS_ALREADY_CHANGED");
            }
        }
        catch (BusinessException e) {
            logger.error((Object)"Error in validateResetPasswordToken :: ActivationServiceImpl ", (Throwable)e);
            throw e;
        }
        return data;
    }

    public void updatePassword(String data, String newPassword) {
        try {
            Optional activationRequestOptional = this.activationRequestRepository.findByEmailOrContact(data);
            if (activationRequestOptional.isEmpty()) {
                throw new BusinessException(99, "ACCOUNT_DOES_NOT_EXIST");
            }
            ActivationRequest activationRequest = (ActivationRequest)activationRequestOptional.get();
            activationRequest.setPassword(passwordEncoder.encode((CharSequence)newPassword));
            activationRequest.setUpdatedDate(new Date());
            this.activationRequestRepository.save((Object)activationRequest);
            this.redisService.clear("RESET_URL_TOKEN_PREFIX" + activationRequest.getEmail());
        }
        catch (Exception e) {
            logger.error((Object)"Error in updatePassword :: ActivationServiceImpl ", (Throwable)e);
            throw e;
        }
    }

    public void isAuthorized(String requestUrl, Long roleId) {
        String[] segments;
        StringBuilder searchURL = new StringBuilder();
        for (String segment : segments = requestUrl.split("/")) {
            if (segment.isEmpty()) continue;
            if (this.isDynamicSegment(segment)) {
                searchURL.append("/").append("{v}");
                continue;
            }
            searchURL.append("/").append(segment);
        }
        if (!this.roleURLViewRepository.hasRights(roleId, 5, searchURL.toString())) {
            throw new BusinessException(500, "UNAUTHORIZED_ACCESS");
        }
    }

    private boolean isDynamicSegment(String segment) {
        if (segment.matches("\\d+")) {
            return true;
        }
        return segment.length() >= 16 && segment.matches("^[A-Za-z0-9\\-_]+=*$") && segment.matches(".*[A-Z].*") && segment.matches(".*[a-z].*");
    }

    @Transactional
    public void logout(Long personId, String ipAddress, String macAddress) {
        Object activationRequest = null;
        Optional aOptional = null;
        try {
            aOptional = this.activationRequestRepository.findByIdPersonId(personId);
            if (aOptional.isEmpty()) {
                throw new BusinessException(500, "PERSON_NOT_FOUND");
            }
            activationRequest.setLogoutDate(new Timestamp(new Date().getTime()));
            activationRequest.setIpAddress(ipAddress);
            activationRequest.setMacAddress(macAddress);
            this.activationRequestRepository.save(activationRequest);
            this.redisService.store(String.valueOf(personId), String.valueOf(personId), 60L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            logger.error((Object)"error in logout :: ActivationServiceImpl ", (Throwable)e);
            throw new BusinessException(500, "SOMETHING_WENT_WRONG");
        }
    }
}

