/*
 * Decompiled with CFR 0.152.
 */
package com.qpaix.auth.serviceimpl;

import com.qpaix.auth.entity.Config;
import com.qpaix.auth.exception.BusinessException;
import com.qpaix.auth.repository.ConfigRepository;
import com.qpaix.auth.service.ConfigService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ConfigServiceImpl
implements ConfigService {
    private static final Log logger = LogFactory.getLog(ConfigServiceImpl.class);
    @Autowired
    @Lazy
    private ConfigRepository configRepository;

    public void checkVersion(String version, int deviceType) {
        Config config = null;
        try {
            if (deviceType == 2) {
                config = (Config)this.configRepository.getConfigByName("ANDROID_VERSION").get();
            } else if (deviceType == 3) {
                config = (Config)this.configRepository.getConfigByName("IOS_VERSION").get();
            } else {
                logger.error((Object)"no version found in database");
                throw new BusinessException(500, "NO_VERSION_FOUND");
            }
            if (this.compareVersions(version, config.getValue()) < 0) {
                throw new BusinessException(426, "APP_VERSION_MIS_MATCHED");
            }
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"error in checkVersion :: ConfigServiceImpl ", (Throwable)e);
            throw new BusinessException(500, "SOMETHING_WENT_WRONG");
        }
    }

    public String getValueByName(String name) {
        Config config = null;
        try {
            config = (Config)this.configRepository.getConfigByName(name).get();
            return config.getValue();
        }
        catch (Exception e) {
            logger.error((Object)"error in getValueByName :: ConfigServiceImpl ", (Throwable)e);
            throw new BusinessException(500, "SOMETHING_WENT_WRONG");
        }
    }

    public int compareVersions(String v1, String v2) {
        String[] parts1 = v1.split("\\.");
        String[] parts2 = v2.split("\\.");
        int length = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < length; ++i) {
            int num2;
            int num1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
            int n = num2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
            if (num1 < num2) {
                return -1;
            }
            if (num1 <= num2) continue;
            return 1;
        }
        return 0;
    }
}

