/*
 * Decompiled with CFR 0.152.
 */
package com.qpaix.auth.serviceimpl;

import com.qpaix.auth.exception.BusinessException;
import com.qpaix.auth.service.EmailService;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.MediaType;
import org.springframework.http.client.MultipartBodyBuilder;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;

@Service
public class EmailServiceImpl
implements EmailService {
    private static final Log logger = LogFactory.getLog(EmailServiceImpl.class);
    @Autowired
    @Lazy
    private JavaMailSender mailSender;
    private final WebClient webClient;
    @Value(value="${spring.mail.username}")
    private String fromEmail;

    public EmailServiceImpl(WebClient webClient) {
        this.webClient = webClient;
    }

    @Async
    public void sendMail(String to, String subject, String content) {
        SimpleMailMessage message = new SimpleMailMessage();
        try {
            message.setFrom(this.fromEmail);
            message.setTo(to);
            message.setSubject(subject);
            message.setText(content);
            this.mailSender.send(message);
            logger.info((Object)("Email has been set to : " + to));
        }
        catch (Exception e) {
            logger.error((Object)"Error in sendSimpleMessage :: EmailServiceImpl", (Throwable)e);
            throw new BusinessException(500, "EMAIL_SENT_FAILURE");
        }
    }

    @Async
    public void sendOtpMessage(String email, String subject, String message) {
        this.sendMail(email, subject, message);
    }

    @Async
    public void sendRegistrationEmail(String email) {
        try {
            SimpleMailMessage message = new SimpleMailMessage();
            message.setTo(email);
            message.setSubject("Account Verification");
            message.setText("Dear User,\n Your contact and email is verified successfully.");
            this.mailSender.send(message);
            logger.info((Object)("Verification mail sent to " + email));
        }
        catch (MailException e) {
            logger.info((Object)("Verification mail sent failed to " + email));
            throw new BusinessException(500, "EMAIL_SENT_FAILURE");
        }
    }

    @Async
    public void sendMail(String to, String subject, String body, String[] cc, String[] bcc, MultipartFile[] attachments) {
        try {
            MultipartBodyBuilder builder = new MultipartBodyBuilder();
            builder.part("from", (Object)this.fromEmail);
            builder.part("to", (Object)to);
            builder.part("subject", (Object)subject);
            builder.part("body", (Object)body);
            if (cc != null) {
                for (String string : cc) {
                    builder.part("cc", (Object)string);
                }
            }
            if (bcc != null) {
                for (String string : bcc) {
                    builder.part("bcc", (Object)string);
                }
            }
            if (attachments != null) {
                for (String string : attachments) {
                    try {
                        builder.part("attachments", (Object)new /* Unavailable Anonymous Inner Class!! */).header("Content-Disposition", new String[]{"form-data; name=\"attachments\"; filename=\"" + string.getOriginalFilename() + "\""});
                    }
                    catch (IOException e) {
                        logger.error((Object)"Failed to read attachment : ", (Throwable)e);
                    }
                }
            }
            ((WebClient.RequestBodySpec)this.webClient.post().uri("/api/email-service", new Object[0])).contentType(MediaType.MULTIPART_FORM_DATA).body((BodyInserter)BodyInserters.fromMultipartData((MultiValueMap)builder.build())).retrieve().toBodilessEntity().subscribe();
        }
        catch (Exception e) {
            logger.error((Object)"error in sendMail :: EmailServiceImpl", (Throwable)e);
            throw new BusinessException(500, "SOMETHING_WENT_WRONG");
        }
    }
}

