/*
 * Decompiled with CFR 0.152.
 */
package com.qpaix.auth.serviceimpl;

import com.qpaix.auth.entity.ActivationRequest;
import com.qpaix.auth.exception.BusinessException;
import com.qpaix.auth.repository.ActivationRequestRepository;
import java.util.Collections;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class JwtUserDetailsServiceImpl
implements UserDetailsService {
    @Autowired
    @Lazy
    private ActivationRequestRepository activationRequestRepository;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        try {
            Optional activationRequestOptional = this.activationRequestRepository.findByEmailOrContact(username.toLowerCase());
            if (activationRequestOptional.isPresent()) {
                ActivationRequest activationRequest = (ActivationRequest)activationRequestOptional.get();
                return new User(activationRequest.getEmail(), activationRequest.getPassword(), Collections.emptyList());
            }
            throw new BusinessException(500, "ACCOUNT_DOES_NOT_EXIST");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BusinessException(500, "Error while login");
        }
    }
}

