/*
 * Decompiled with CFR 0.152.
 */
package com.qpaix.auth.serviceimpl;

import com.qpaix.auth.dto.PersonInfoDTO;
import com.qpaix.auth.entity.PersonInfo;
import com.qpaix.auth.exception.BusinessException;
import com.qpaix.auth.repository.PersonInfoRepository;
import com.qpaix.auth.service.PersonInfoService;
import com.qpaix.auth.util.EncryptionDecryption;
import java.util.Objects;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class PersonInfoServiceImpl
implements PersonInfoService {
    private static final Log logger = LogFactory.getLog(PersonInfoServiceImpl.class);
    @Autowired
    @Lazy
    private PersonInfoRepository personInfoRepository;
    @Autowired
    EncryptionDecryption encryptionDecryption;

    public PersonInfoDTO getPersonInfoById(String encryptedPersonId) throws Exception {
        Optional pOptional = null;
        Long personId = null;
        PersonInfoDTO personInfoDTO = new PersonInfoDTO();
        try {
            Long l = personId = Objects.nonNull(encryptedPersonId) && !encryptedPersonId.isEmpty() ? Long.valueOf(this.encryptionDecryption.decrypt(encryptedPersonId)) : null;
            if (Objects.nonNull(personId)) {
                pOptional = this.personInfoRepository.getPersonInfoById(personId);
            }
        }
        catch (Exception e) {
            logger.error((Object)"error in getPersonInfoById :: PersonInfoServiceImpl ", (Throwable)e);
            throw e;
        }
        return personInfoDTO;
    }

    public boolean checkPersonExistById(String encryptedPersonId) throws Exception {
        Long personId = null;
        try {
            Long l = personId = Objects.nonNull(encryptedPersonId) && !encryptedPersonId.isEmpty() ? Long.valueOf(this.encryptionDecryption.decrypt(encryptedPersonId)) : null;
            if (Objects.nonNull(personId) && this.personInfoRepository.existsById(personId)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"error in checkPersonExistById :: PersonInfoServiceImpl ", (Throwable)e);
            throw e;
        }
        return false;
    }

    @Transactional
    public void updatePeronDetail(PersonInfoDTO personInfoDTO, String ipAddress, String macAddress) {
        Optional pOptional = null;
        PersonInfo personInfo = null;
        try {
            pOptional = this.personInfoRepository.getPersonInfoById(Long.valueOf(this.encryptionDecryption.decrypt(personInfoDTO.getEncryptedPersonId())));
            if (!pOptional.isPresent()) {
                throw new BusinessException(500, "Person not exist");
            }
            personInfo = (PersonInfo)pOptional.get();
            if (personInfo.isDetailsSubmitted()) {
                logger.error((Object)"Person has already submited details");
                throw new BusinessException(500, "PERSON_ALREADY_EXIST");
            }
            BeanUtils.copyProperties((Object)personInfoDTO, (Object)personInfo);
            personInfo.setDetailsSubmitted(true);
            personInfo.setIpAddress(ipAddress);
            personInfo.setMacAddress(macAddress);
            this.personInfoRepository.save((Object)personInfo);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"error in updatePeronDetail :: PersonInfoServiceImpl ", (Throwable)e);
        }
    }
}

