/*
 * Decompiled with CFR 0.152.
 */
package com.qpaix.auth.serviceimpl;

import com.qpaix.auth.dto.PersonRoleViewDTO;
import com.qpaix.auth.entity.PersonRoleView;
import com.qpaix.auth.exception.BusinessException;
import com.qpaix.auth.repository.PersonRoleViewRepository;
import com.qpaix.auth.service.PersonRoleViewService;
import com.qpaix.auth.util.EncryptionDecryption;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class PersonRoleViewServiceImpl
implements PersonRoleViewService {
    @Autowired
    @Lazy
    private PersonRoleViewRepository personRoleViewRepository;
    @Autowired
    @Lazy
    private EncryptionDecryption encryptionDecryption;

    public List<PersonRoleViewDTO> getAssignedRolesByPersonId(Long personId) throws Exception {
        ArrayList<PersonRoleViewDTO> personRoleViewDTOs = new ArrayList<PersonRoleViewDTO>();
        List personRoleViews = null;
        try {
            personRoleViews = this.personRoleViewRepository.getAssignedRolesByPersonId(personId);
            personRoleViews.forEach(ele -> {
                try {
                    personRoleViewDTOs.add(new PersonRoleViewDTO(this.encryptionDecryption.encrypt((Object)ele.getRoleId()), ele.getHierarchy(), ele.getRoleName(), ele.isDefault()));
                }
                catch (Exception ex) {
                    Logger.getLogger(PersonRoleViewServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BusinessException(500, "SOMETHING_WENT_WRONG");
        }
        return personRoleViewDTOs;
    }

    public PersonRoleViewDTO getAssignedRoleByPersonId(Long personId, Long roleId) {
        Optional pOptional = null;
        PersonRoleView personRoleView = null;
        try {
            pOptional = this.personRoleViewRepository.getAssignedRole(personId, roleId);
            if (pOptional.isPresent()) {
                personRoleView = (PersonRoleView)pOptional.get();
                return new PersonRoleViewDTO(this.encryptionDecryption.encrypt((Object)personRoleView.getRoleId()), personRoleView.getHierarchy(), personRoleView.getRoleName(), personRoleView.isDefault());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

