/*
 * Decompiled with CFR 0.152.
 */
package com.qpaix.auth.util;

import com.qpaix.auth.config.JwtTokenUtil;
import com.qpaix.auth.dto.TokenDetailsDTO;
import com.qpaix.auth.exception.BusinessException;
import com.qpaix.auth.util.EncryptionDecryption;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class CommonUtil {
    @Value(value="${token.extract.key}")
    private static String secretKey;
    @Autowired
    @Lazy
    private JwtTokenUtil jwtTokenUtil;
    @Autowired
    @Lazy
    private EncryptionDecryption encryptionDecryption;
    private static final Log logger;

    public static String getClientIpAddress(ServerHttpRequest request) {
        return Optional.ofNullable(request.getHeaders().getFirst("X-Forwarded-For")).map(ip -> ip.split(",")[0]).orElse(request.getRemoteAddress() != null ? request.getRemoteAddress().getAddress().getHostAddress() : "UNKNOWN");
    }

    public static String getClientMacAddress(ServerHttpRequest request) {
        try {
            byte[] macArray;
            String clientIp = CommonUtil.getClientIpAddress((ServerHttpRequest)request);
            if ("UNKNOWN".equals(clientIp)) {
                return "UNKNOWN";
            }
            InetAddress inetAddress = InetAddress.getByName(clientIp);
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inetAddress);
            if (networkInterface != null && (macArray = networkInterface.getHardwareAddress()) != null) {
                StringBuilder macStringBuilder = new StringBuilder();
                for (int i = 0; i < macArray.length; ++i) {
                    macStringBuilder.append(String.format("%02X%s", macArray[i], i < macArray.length - 1 ? "-" : ""));
                }
                return macStringBuilder.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "UNKNOWN";
    }

    public TokenDetailsDTO getDataFromToken(ServerHttpRequest request) throws Exception {
        try {
            String authorizationHeader = request.getHeaders().getFirst("Authorization");
            if (Objects.isNull(authorizationHeader) || !authorizationHeader.startsWith("Bearer ")) {
                throw new BusinessException(401, "UNAUTHORIZED_ACCESS");
            }
            String token = authorizationHeader.substring(7);
            Map claims = this.jwtTokenUtil.extractAllData(token);
            String password = this.getDecryptedString(claims, "PASSWORD");
            String email = (String)claims.get("EMAIL");
            Long companyId = this.getDecryptedLong(claims, "COMPANY_ID");
            Long roleId = this.getDecryptedLong(claims, "ROLE_ID");
            String roleName = (String)claims.get("ROLE");
            Long personId = this.getDecryptedLong(claims, "PERSON_ID");
            Long branchId = this.getDecryptedLong(claims, "BRANCH_ID");
            Integer hierarchy = this.getDecryptedInteger(claims, "HIERARCHY");
            return new TokenDetailsDTO(roleName, roleId, companyId, personId, branchId, hierarchy, email, password);
        }
        catch (ExpiredJwtException | MalformedJwtException | SignatureException | UnsupportedJwtException | IllegalArgumentException e) {
            logger.error((Object)"Invalid or expired JWT token", e);
            throw e;
        }
    }

    private Long getDecryptedLong(Map<String, Object> claims, String key) throws Exception {
        Object value = claims.get(key);
        return value != null ? Long.valueOf(this.encryptionDecryption.decrypt((String)value)) : null;
    }

    private Integer getDecryptedInteger(Map<String, Object> claims, String key) throws Exception {
        Object value = claims.get(key);
        return value != null ? Integer.valueOf(this.encryptionDecryption.decrypt((String)value)) : null;
    }

    private String getDecryptedString(Map<String, Object> claims, String key) throws Exception {
        Object value = claims.get(key);
        return value != null ? this.encryptionDecryption.decrypt((String)value) : null;
    }

    static {
        logger = LogFactory.getLog(CommonUtil.class);
    }
}

