/*
 * Decompiled with CFR 0.152.
 */
package com.qpaix.auth.util;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class EncryptionDecryption {
    private static final String AES_ALGORITHM = "AES";
    @Value(value="${encryption.key}")
    private String secretKeyString;
    private SecretKeySpec secretKey;

    @PostConstruct
    public void init() {
        byte[] keyBytes = this.secretKeyString.getBytes(StandardCharsets.UTF_8);
        byte[] key = new byte[16];
        System.arraycopy(keyBytes, 0, key, 0, Math.min(keyBytes.length, key.length));
        this.secretKey = new SecretKeySpec(key, AES_ALGORITHM);
    }

    public String encrypt(Object data) throws Exception {
        if (Objects.nonNull(data)) {
            Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
            cipher.init(1, this.secretKey);
            byte[] encryptedBytes = cipher.doFinal(String.valueOf(data).getBytes(StandardCharsets.UTF_8));
            return Base64.getUrlEncoder().encodeToString(encryptedBytes);
        }
        return null;
    }

    public String decrypt(String encryptedData) throws Exception {
        if (Objects.nonNull(encryptedData)) {
            Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
            cipher.init(2, this.secretKey);
            byte[] decryptedBytes = cipher.doFinal(Base64.getUrlDecoder().decode(encryptedData));
            return new String(decryptedBytes, StandardCharsets.UTF_8);
        }
        return null;
    }
}

